// ModuleInterface.h: interface for the CModuleInterface class.
// Version 3.1    6 Setember 2007 Rewrite to use serial port
// Version 3.2   16 November 2007 File made common to all USB modules
//////////////////////////////////////////////////////////////////////
#include "serialport.h"

#if !defined(AFX_MODULEINTERFACE_H__817B8108_B113_4391_A834_F0AF4BEF1797__INCLUDED_)
#define AFX_MODULEINTERFACE_H__817B8108_B113_4391_A834_F0AF4BEF1797__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

typedef enum
{
	OutputState = 0,
	InputState = 1
} PortDirection;

class CModuleInterface  
{
private:
	CSerialPort * mPort;

	char mcLowerRelay[7];
	char mcUpperRelay[7];
	bool mbPortNotReady;
	CString mPortNum;

	unsigned char mDataPortBDirControl;
	unsigned char mDataPortCDirControl;
	unsigned char mDataPortDDirControl;

public:
	// Constructors/Destructors
	CModuleInterface();
	CModuleInterface(CSerialPort *ModulePort);

	virtual ~CModuleInterface();

	// Communication port Access
	int  ReadCommPort (void);
	int  WriteToCommPort (char * Buffer, int Length);
	void CreateCommPort (int PortNum);
	BOOL SetComPortNum(int ComPortNum);

    // Relay control functions
	void SetPortStates(char Port,PortDirection Dir, unsigned char Mask);
    void SendCommand (char ControlChar, int Value);
	bool ActivateRelay(int uPosition, char iBank, int OnOff );
	void ActivateBank(char uBank);
	void ClearRelays(int NumRelays);
	void CloseRelay(int RelNum, int RelBank);
	void OpenRelay(int RelNum, int RelBank);
	void CloseRelay(int RelayPosition);
	void OpenRelay(int RelayPosition);

	// Inout port read functions
	void ClearPorts();
	int  ReadDataPortVal (char Port);
};

#endif // !defined(AFX_MODULEINTERFACE_H__817B8108_B113_4391_A834_F0AF4BEF1797__INCLUDED_)
