// USB16VIDlg.cpp : implementation file
// Version 1.1    6 Setember 2007 Initial version
// Version 1.2   16 November 2007 Used common ModuleInterface file
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "ModuleInterface.h"
#include "CommPortSelect.h"
#include "serialport.h"
#include "USB16VI.h"
#include "USB16VIDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define SCAN_INTERVAL_TIMER 2000

/////////////////////////////////////////////////////////////////////////////
// Serial port instance

	CSerialPort *port = new CSerialPort();
	CModuleInterface *ControlInterface = new CModuleInterface(port);

/////////////////////////////////////////////////////////////////////////////
// Select port Dialog instance
	CCommPortSelect selectdlg ;

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CUSB16VIDlg dialog

CUSB16VIDlg::CUSB16VIDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CUSB16VIDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CUSB16VIDlg)
	mCommPort = 0;
	mDataPortSampleRate = 0;
	mDataPortValue = _T("");
	mDataPortBValue = _T("");
	mDataPortCValue = _T("");
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CUSB16VIDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CUSB16VIDlg)
	DDX_Control(pDX, IDC_SCAN_BUTTON, mSelectPortScan);
	DDX_Control(pDX, IDC_DATA_PORT_INT_SCROLL, m_vsbCycleInterval);
	DDX_Text(pDX, IDC_COMM_PORT_SELECTED, mCommPort);
	DDV_MinMaxInt(pDX, mCommPort, 1, 99);
	DDX_Text(pDX, IDC_PORT_SAMPLE_RATE, mDataPortSampleRate);
	DDX_Text(pDX, IDC_DATA_PORT_B_VALUE, mDataPortBValue);
	DDX_Text(pDX, IDC_DATA_PORT_C_VALUE, mDataPortCValue);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CUSB16VIDlg, CDialog)
	//{{AFX_MSG_MAP(CUSB16VIDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_COMMAND(ID_COMMPORT_COMM1, OnCommportComm1)
	ON_COMMAND(ID_COMMPORT_COMM2, OnCommportComm2)
	ON_COMMAND(ID_COMMPORT_COMM3, OnCommportComm3)
	ON_COMMAND(ID_COMMPORT_COMM4, OnCommportComm4)
	ON_COMMAND(ID_COMMPORT_COMM5, OnCommportComm5)
	ON_COMMAND(ID_COMMPORT_SELECTPORT, OnCommportSelectport)
	ON_BN_CLICKED(IDC_SCAN_BUTTON, OnScanButton)
	ON_WM_VSCROLL()
	ON_WM_CLOSE()
	ON_COMMAND(ID_FILE_EXIT, OnFileExit)
	ON_WM_TIMER()
	ON_COMMAND(ID_HELP_ABOUT, OnHelpAbout)
	ON_COMMAND(ID_HELP_DEVICEMANAGER, OnHelpDevicemanager)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CUSB16VIDlg message handlers

BOOL CUSB16VIDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	
	////////////////////////////////////////////////////////////////////
	// Load Menues
	// Set pointers to Com port sub menu items 
	m_mainMenu = GetMenu();
	m_pmnuPort = m_mainMenu->GetSubMenu(1);
	m_pmnuData = m_mainMenu->GetSubMenu(2);
	
	m_vsbCycleInterval.SetScrollRange(10,1000,TRUE);
	m_vsbCycleInterval.SetScrollPos(500, FALSE);

	mDataPortSampleRate = 500;
	mVScrollPos = 500;

	////////////////////////////////////////////////////////////////////
    // Set up com port
    if (SetUpComPort())
	{
		//  Setup Control status
		mCommPort = mPort;
		SetUpControls();
		EnableControls();
		UpdateData(FALSE);
	}
	else
	{
		CDialog::OnCancel();
	}
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CUSB16VIDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CUSB16VIDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CUSB16VIDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CUSB16VIDlg::EnableControls(void)
{
    Initialise();
}

void CUSB16VIDlg::DisableControls(void)
{
	// Unused
}

void CUSB16VIDlg::SetUpControls(void)
{
	// Unused
}

void CUSB16VIDlg::Initialise(void)
{
    // Set all PIC ports to Outputs
    ControlInterface->SetPortStates ('B',InputState,0xFF);
    ControlInterface->SetPortStates ('C',InputState,0xFF);    
	UpdateData(FALSE);
}

bool CUSB16VIDlg::SetUpComPort(void)
{
	int PortNum;
	CString dummyString;
    char buffer [10];

	int nResponse = selectdlg.DoModal();

	if (nResponse == IDOK)
	{
		//  Code here to handle when the dialog is
		//  dismissed with OK
		PortNum = selectdlg.PortValue();
		sprintf(buffer,"Com%d", PortNum);

		return SelectCommPort (PortNum);
	}
	return false;
}

// Selects the communication port and sets menu checks
bool CUSB16VIDlg::SelectCommPort(int portnum)
{
    char buffer[10];

	m_pmnuPort->CheckMenuItem(0,MF_UNCHECKED | MF_BYPOSITION);
	m_pmnuPort->CheckMenuItem(1,MF_UNCHECKED | MF_BYPOSITION);
	m_pmnuPort->CheckMenuItem(2,MF_UNCHECKED | MF_BYPOSITION);
	m_pmnuPort->CheckMenuItem(3,MF_UNCHECKED | MF_BYPOSITION);
	m_pmnuPort->CheckMenuItem(4,MF_UNCHECKED | MF_BYPOSITION);
    
	m_pmnuPort->CheckMenuItem(portnum - 1,MF_CHECKED | MF_BYPOSITION);


	CString sPortName;

	switch(portnum)
	{
		case 1 : sPortName = "Com1"; break;
		case 2 : sPortName = "Com2"; break;
		case 3 : sPortName = "Com3"; break;
		case 4 : sPortName = "Com4"; break;
		case 5 : sPortName = "Com5"; break;
		default :
			sprintf(buffer,"Com%d",portnum);
			sPortName = buffer;
			break;
	}

    if (ControlInterface->SetComPortNum(portnum) == TRUE )
    {
		mPort = portnum;
	    ControlInterface->CreateCommPort(mPort);
        mCommPort = mPort;
        EnableControls();
		Initialise();
		return true;
    } 
    else
    {
        mPort = 0;
        mCommPort = mPort;
        DisableControls();
        MessageBox ("Invalid Comm Port", "COMM PORT", MB_OK | MB_ICONEXCLAMATION);
 		return false;
   }

    UpdateData(FALSE);

}

void CUSB16VIDlg::OnCommportComm1() 
{
	mPort = 1;
	SelectCommPort(mPort);
}

void CUSB16VIDlg::OnCommportComm2() 
{
	mPort = 2;
	SelectCommPort(mPort);
}

void CUSB16VIDlg::OnCommportComm3() 
{
	mPort = 3;
	SelectCommPort(mPort);
	
}

void CUSB16VIDlg::OnCommportComm4() 
{
	mPort = 4;
	SelectCommPort(mPort);
}

void CUSB16VIDlg::OnCommportComm5() 
{
	mPort = 5;
	SelectCommPort(mPort);
}

void CUSB16VIDlg::OnCommportSelectport() 
{
	int nResponse = selectdlg.DoModal();
	if (nResponse == IDOK)
	{
		//  Code here to handle when the dialog is
		//  dismissed with OK
		mPort = selectdlg.PortValue();

    	SelectCommPort(mPort);
	}
	else if (nResponse == IDCANCEL)
	{

	}		
}

void CUSB16VIDlg::OnScanButton() 
{
	CString ScanText;

	mSelectPortScan.GetWindowText (ScanText); 

	if ( ScanText == "StartScan")
	{
		mSelectPortScan.SetWindowText("StopScan");

		SetTimer (SCAN_INTERVAL_TIMER, mDataPortSampleRate,NULL );
	}
	else
	{
		mSelectPortScan.SetWindowText("StartScan");

		KillTimer (SCAN_INTERVAL_TIMER);
	}
	
}


void CUSB16VIDlg::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	mVScrollPos = m_vsbCycleInterval.GetScrollPos();

	switch (nSBCode)
	{
	case SB_BOTTOM:      // Scroll to far left.
		mVScrollPos = 0;
		break;

	case SB_TOP:      // Scroll to far right.
		mVScrollPos = 1000;
		break;

	case SB_ENDSCROLL:   // End scroll.
		break;

	case SB_LINEDOWN:      // Scroll down.
		if (mVScrollPos < 1000)
			mVScrollPos+= 10;
		break;

	case SB_LINEUP:   // Scroll up.
		if (mVScrollPos > 10)
			mVScrollPos-= 10;
		break;

	case SB_PAGEUP:    // Scroll one page up.
		{
			if (mVScrollPos > 0)
				mVScrollPos = max(0, mVScrollPos - 100);

		}
		break;

	case SB_PAGEDOWN:      // Scroll one page down
		{
			if (mVScrollPos < 1000)
				mVScrollPos = min(1000, mVScrollPos + 100);
		}
		break;

	case SB_THUMBPOSITION: // Scroll to absolute position. nPos is the position
		mVScrollPos = (nPos/10) * 10;      // of the scroll box at the end of the drag operation.
		break;

	case SB_THUMBTRACK:      // Drag scroll box to specified position. nPos is the
		mVScrollPos = (nPos/10) * 10; // position that the scroll box has been dragged to.
		break;
	}

	// Set the new position of the thumb (scroll box).
	m_vsbCycleInterval.SetScrollPos(mVScrollPos, TRUE);

	CDialog::OnVScroll(nSBCode, nPos, pScrollBar);

	mDataPortSampleRate = mVScrollPos;
	UpdateData(FALSE);
}

void CUSB16VIDlg::OnClose() 
{
   //Form.close;
	CDialog::OnCancel();
}

void CUSB16VIDlg::OnFileExit() 
{
   //Form.close;
	CDialog::OnCancel();	
}

void CUSB16VIDlg::OnTimer(UINT nIDEvent) 
{
	int PortValue;
	char Buffer[10];

	PortValue = ControlInterface->ReadDataPortVal('B');
	sprintf (Buffer, "0x%X", PortValue);
	mDataPortBValue = Buffer;

	PortValue = ControlInterface->ReadDataPortVal('C');
	sprintf (Buffer, "0x%X", PortValue);
	mDataPortCValue = Buffer;
	UpdateData(FALSE);

	SetTimer (SCAN_INTERVAL_TIMER, mDataPortSampleRate,NULL );

	CDialog::OnTimer(nIDEvent);
}

void CUSB16VIDlg::OnHelpAbout() 
{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
}

void CUSB16VIDlg::OnHelpDevicemanager() 
{
	int response = system("C://WINDOWS//system32//mmc.exe C://WINDOWS//system32//devmgmt.msc //s");	
}
